/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.commandline.Helper;

class CmdLineInfoPart
implements ISVNInfo {
    private static final String KEY_PATH = "Path";
    private static final String KEY_URL = "URL";
    private static final String KEY_REVISION = "Revision";
    private static final String KEY_REPOSITORY = "Repository Root";
    private static final String KEY_NODEKIND = "Node Kind";
    private static final String KEY_LASTCHANGEDAUTHOR = "Last Changed Author";
    private static final String KEY_LASTCHANGEDREV = "Last Changed Rev";
    private static final String KEY_LASTCHANGEDDATE = "Last Changed Date";
    private static final String KEY_TEXTLASTUPDATED = "Text Last Updated";
    private static final String KEY_SCHEDULE = "Schedule";
    private static final String KEY_COPIEDFROMURL = "Copied From URL";
    private static final String KEY_COPIEDFROMREV = "Copied From Rev";
    private static final String KEY_PROPSLASTUPDATED = "Properties Last Updated";
    private static final String KEY_REPOSITORYUUID = "Repository UUID";
    private static final String KEY_LOCKOWNER = "Lock Owner";
    private static final String KEY_LOCKCREATIONDATE = "Lock Created";
    private static final String KEY_LOCKCOMMENT = "Lock Comment";
    private Map infoMap = new HashMap();
    protected boolean unversioned = false;

    CmdLineInfoPart(String string) {
        this();
        this.load(string);
    }

    private CmdLineInfoPart() {
    }

    public Date getLastChangedDate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_LASTCHANGEDDATE));
    }

    public SVNRevision.Number getLastChangedRevision() {
        return this.unversioned ? null : Helper.toRevNum(this.get(KEY_LASTCHANGEDREV));
    }

    public String getLastCommitAuthor() {
        return this.unversioned ? null : this.get(KEY_LASTCHANGEDAUTHOR);
    }

    public SVNNodeKind getNodeKind() {
        return this.unversioned ? null : SVNNodeKind.fromString(this.get(KEY_NODEKIND));
    }

    public String getPath() {
        return this.get(KEY_PATH);
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public SVNRevision.Number getRevision() {
        return this.unversioned ? SVNRevision.INVALID_REVISION : Helper.toRevNum(this.get(KEY_REVISION));
    }

    public SVNUrl getUrl() {
        return this.unversioned ? null : Helper.toSVNUrl(this.get(KEY_URL));
    }

    private String get(String string) {
        Object v = this.infoMap.get(string);
        return v == null ? null : v.toString();
    }

    private void load(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, Helper.NEWLINE);
        if (stringTokenizer.countTokens() == 1) {
            this.unversioned = true;
            String string2 = stringTokenizer.nextToken();
            this.infoMap.put(KEY_PATH, string2.substring(0, string2.indexOf(":  (Not a versioned resource)")));
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (bl) {
                    stringBuffer.append(string3).append("\n");
                    continue;
                }
                int n = string3.indexOf(58);
                String string4 = string3.substring(0, n);
                if (string4.startsWith(KEY_LOCKCOMMENT)) {
                    bl = true;
                    continue;
                }
                String string5 = string3.substring(n + 2);
                this.infoMap.put(string4, string5);
            }
            if (bl) {
                this.infoMap.put(KEY_LOCKCOMMENT, stringBuffer.toString());
            }
        }
    }

    public boolean isVersioned() {
        return !this.unversioned;
    }

    public Date getLastDateTextUpdate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_TEXTLASTUPDATED));
    }

    public String getUuid() {
        return this.unversioned ? null : this.get(KEY_REPOSITORYUUID);
    }

    public SVNUrl getRepository() {
        return this.unversioned ? null : Helper.toSVNUrl(this.get(KEY_REPOSITORY));
    }

    public SVNScheduleKind getSchedule() {
        return SVNScheduleKind.fromString(this.get(KEY_SCHEDULE));
    }

    public Date getLastDatePropsUpdate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_PROPSLASTUPDATED));
    }

    public boolean isCopied() {
        return this.getCopyRev() != null || this.getCopyUrl() != null;
    }

    public SVNRevision.Number getCopyRev() {
        return this.unversioned ? null : Helper.toRevNum(this.get(KEY_COPIEDFROMREV));
    }

    public SVNUrl getCopyUrl() {
        return this.unversioned ? null : Helper.toSVNUrl(this.get(KEY_COPIEDFROMURL));
    }

    public Date getLockCreationDate() {
        return this.unversioned ? null : Helper.toDate(this.get(KEY_LOCKCREATIONDATE));
    }

    public String getLockOwner() {
        return this.unversioned ? null : this.get(KEY_LOCKOWNER);
    }

    public String getLockComment() {
        return this.unversioned ? null : this.get(KEY_LOCKCOMMENT);
    }

    public static String[] parseInfoParts(String string) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, Helper.NEWLINE);
        Object object = null;
        ArrayList<String[]> arrayList = new ArrayList<String[]>(stringTokenizer.countTokens());
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (stringArray.startsWith("Path:") || stringArray.endsWith(":  (Not a versioned resource)")) {
                if (object != null) {
                    arrayList.add((String[])object);
                }
                object = stringArray;
                continue;
            }
            if (object == null) {
                object = stringArray;
                continue;
            }
            object = (String)object + "\n" + (String)stringArray;
        }
        if (object != null) {
            arrayList.add((String[])object);
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static CmdLineInfoPart createUnversioned(String string) {
        return new CmdLineInfoPartUnversioned(string);
    }

    protected static class CmdLineInfoPartUnversioned
    extends CmdLineInfoPart {
        private String path;

        private CmdLineInfoPartUnversioned(String string) {
            this.path = string;
            this.unversioned = true;
        }

        public String getPath() {
            return this.path;
        }
    }
}

